<?php 
/* 
Template Name: Template - Default with Sidebar
*/ 
?>
<?php get_header(); // add header ?> 
<?php
    // Display First Content Letter
    $multicote_wp_display_letter = get_theme_mod('multicote_wp_display_letter');
    if (empty($multicote_wp_display_letter)) { $multicote_wp_display_letter = 'No'; }        
?>

<!-- Begin Content -->
<div class="wrap-fullwidth">

    <div class="single-content">
        <article>
            <?php if (have_posts()) : while (have_posts()) : the_post();  ?>
            <div <?php post_class(); ?> id="post-<?php the_ID(); ?>">             

                        <div class="entry">
                          <h1 class="page-title"><?php the_title(); ?></h1>
                        <?php if ($multicote_wp_display_letter == 'No') { ?>
                            <?php the_content(''); // content ?>
                        <?php } else { ?>                        
                        <div class="p-first-letter">
                            <?php the_content(''); // content ?>
                        </div><!-- end .p-first-letter -->
                        <?php } ?>
                        <?php wp_link_pages(); // content pagination ?>
                          <div class="clear"></div><br />
                        </div><!-- end #entry -->
            </div><!-- end .post -->
            <?php endwhile; endif; ?>
        </article>

        <?php // If comments are open or we have at least one comment, load up the comment template.
        if ( comments_open() || get_comments_number() ) { ?>
        <!-- Comments -->
        <div class="entry-bottom">
            <?php if ( ! post_password_required() ) { ?>
                <?php if (get_comments_number()==0) { } else { ?>
                    <h3 class="title"><i></i> <?php esc_html_e( 'Comments', 'multicote-wp' ); ?></h3>
                <?php } ?>            
            <?php } ?>    
            
            <!-- Comments -->
            <div id="comments" class="comments">
                <?php comments_template('', true); // comments ?>
            </div>
            <div class="clear"></div>
        </div><!-- end .entry-bottom -->
        <?php } ?> 

    </div><!-- end .single-content -->

    <!-- Begin Sidebar (right) -->
    <?php  get_sidebar(); // add sidebar ?>
    <!-- end #sidebar  (right) -->    

    <div class="clear"></div>
</div><!-- end .wrap-fullwidth -->

<?php get_footer(); // add footer  ?>